<?php
/**
 * API Index / Documentation
 */

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>PII Detection API v1.0</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 40px 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 12px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px;
            text-align: center;
        }
        .header h1 {
            font-size: 2.5em;
            margin-bottom: 10px;
        }
        .header p {
            font-size: 1.2em;
            opacity: 0.9;
        }
        .content {
            padding: 40px;
        }
        .endpoint {
            background: #f8f9fa;
            border-left: 4px solid #667eea;
            padding: 20px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .endpoint h3 {
            color: #667eea;
            margin-bottom: 10px;
        }
        .method {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 4px;
            font-weight: bold;
            font-size: 0.85em;
            margin-right: 10px;
        }
        .post { background: #28a745; color: white; }
        .get { background: #007bff; color: white; }
        .delete { background: #dc3545; color: white; }
        code {
            background: #e9ecef;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
            font-size: 0.9em;
        }
        .features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin: 30px 0;
        }
        .feature {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            text-align: center;
        }
        .feature-icon {
            font-size: 3em;
            margin-bottom: 10px;
        }
        .btn {
            display: inline-block;
            background: #667eea;
            color: white;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 6px;
            margin: 10px 5px;
            font-weight: bold;
        }
        .btn:hover {
            background: #764ba2;
        }
        .status {
            text-align: center;
            padding: 20px;
            background: #d4edda;
            color: #155724;
            border-radius: 8px;
            margin: 20px 0;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔒 PII Detection API</h1>
            <p>Secure RESTful API for Document PII Detection</p>
            <p style="font-size: 0.9em; margin-top: 10px;">Version 1.0</p>
        </div>
        
        <div class="content">
            <div class="status">
                ✅ API Status: Operational
            </div>
            
            <h2>📡 API Endpoints</h2>
            
            <div class="endpoint">
                <h3><span class="method post">POST</span> Create Thread</h3>
                <code>/api/v1/thread_create.php</code>
                <p style="margin-top: 10px;">Create a new thread and receive authentication credentials.</p>
            </div>
            
            <div class="endpoint">
                <h3><span class="method post">POST</span> Process File</h3>
                <code>/api/v1/process_file.php</code>
                <p style="margin-top: 10px;">Process a base64-encoded document and detect PII.</p>
            </div>
            
            <div class="endpoint">
                <h3><span class="method get">GET</span> Thread Info</h3>
                <code>/api/v1/thread_info.php</code>
                <p style="margin-top: 10px;">Get information about a specific thread.</p>
            </div>
            
            <div class="endpoint">
                <h3><span class="method delete">DELETE</span> Delete Thread</h3>
                <code>/api/v1/thread_delete.php</code>
                <p style="margin-top: 10px;">Delete a thread and all associated data.</p>
            </div>
            
            <h2 style="margin-top: 40px;">✨ Features</h2>
            
            <div class="features">
                <div class="feature">
                    <div class="feature-icon">🔐</div>
                    <h4>Secure Authentication</h4>
                    <p>Private key per thread</p>
                </div>
                <div class="feature">
                    <div class="feature-icon">⚡</div>
                    <h4>Smart Caching</h4>
                    <p>60-80% API reduction</p>
                </div>
                <div class="feature">
                    <div class="feature-icon">🔒</div>
                    <h4>Data Isolation</h4>
                    <p>Complete segregation</p>
                </div>
                <div class="feature">
                    <div class="feature-icon">📊</div>
                    <h4>PII Detection</h4>
                    <p>AWS Textract + Comprehend</p>
                </div>
            </div>
            
            <div style="text-align: center; margin-top: 40px;">
                <a href="README.md" class="btn">📚 Documentation</a>
                <a href="test_api.php" class="btn">🧪 Run Tests</a>
            </div>
            
            <h2 style="margin-top: 40px;">🚀 Quick Example</h2>
            <div style="background: #2d2d2d; color: #fff; padding: 20px; border-radius: 8px; overflow-x: auto;">
                <pre style="margin: 0;">// 1. Create thread
const response = await fetch('/api/v1/thread_create.php', {
  method: 'POST',
  headers: { 'Content-Type': 'application/json' },
  body: JSON.stringify({ metadata: { user_id: '12345' } })
});

const { thread_id, private_key } = await response.json();

// 2. Process file
await fetch('/api/v1/process_file.php', {
  method: 'POST',
  body: JSON.stringify({
    thread_id,
    private_key,
    file_data: base64FileData,
    file_name: 'document.pdf'
  })
});</pre>
            </div>
            
            <p style="margin-top: 30px; text-align: center; color: #6c757d;">
                For complete documentation, see <a href="README.md" style="color: #667eea;">README.md</a>
            </p>
        </div>
    </div>
</body>
</html>
